------------------------------------------------------------------------------
-- Particle Physics Detector Electronics Support 
-- University of Wisconsin
-- Lawrence Berkeley National Laboratory (c) 1999
-- ReadOutDriver Electronics
--
------------------------------------------------------------------------------
-- Filename: TrailerToFIFODetect.vhd
-- Description:
--
------------------------------------------------------------------------------
-- Structure:
--
------------------------------------------------------------------------------
-- Timing:
--    *The Engine FPGA runs at 40MHz => clk40
--    *The timing structure of all engine code will be:
--      1.  Latch inputs on positive edge of clk40
--      2.  Perform all logic operations on positive edge of clk40
--      3.  Perform all memory operations on positive edge of clk40
--
------------------------------------------------------------------------------
-- Author:         Mark L. Nagel
-- Board Engineer: 
-- History:
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- LIBRARY INCLUDES
------------------------------------------------------------------------------
library IEEE ;
use IEEE.std_logic_1164.all ; -- needed for logic operations
use IEEE.std_logic_arith.all; -- needed for +/- operations

------------------------------------------------------------------------------
-- PORT DECLARATION
------------------------------------------------------------------------------

entity trailer_to_fifo_detect is
  port(
    clk_in              : in  std_logic; -- 
    rst_n_in            : in  std_logic; --
    show_trailer_flags  : in  std_logic; --
 -- Trailer signals from formatters
    trailer_to_fifo_in  : in  std_logic_vector(11 downto 0);
 -- Trapped trailers to the RRIF
    trailer_to_fifo_out : out std_logic_vector(11 downto 0)
    );
end trailer_to_fifo_detect;

architecture rtl of trailer_to_fifo_detect is
------------------------------------------------------------------------------
-- SIGNAL DECLARATION
------------------------------------------------------------------------------
signal trailer_to_fifo_i : std_logic_vector (11 downto 0);
------------------------------------------------------------------------------
-- PROCESS DECLARATION
------------------------------------------------------------------------------
begin

trailer_to_fifo_detect : process (
  clk_in, 
  rst_n_in
  )
begin
  if (rst_n_in = '0') then
    trailer_to_fifo_i   <= (others => '0');
    trailer_to_fifo_out <= (others => '0');
  elsif (clk_in'event and clk_in = '1') then
    if (show_trailer_flags = '0') then
      trailer_to_fifo_i(11) <= trailer_to_fifo_in(11) OR trailer_to_fifo_i(11);
      trailer_to_fifo_i(10) <= trailer_to_fifo_in(10) OR trailer_to_fifo_i(10);
      trailer_to_fifo_i( 9) <= trailer_to_fifo_in( 9) OR trailer_to_fifo_i( 9);
      trailer_to_fifo_i( 8) <= trailer_to_fifo_in( 8) OR trailer_to_fifo_i( 8);
      trailer_to_fifo_i( 7) <= trailer_to_fifo_in( 7) OR trailer_to_fifo_i( 7);
      trailer_to_fifo_i( 6) <= trailer_to_fifo_in( 6) OR trailer_to_fifo_i( 6);
      trailer_to_fifo_i( 5) <= trailer_to_fifo_in( 5) OR trailer_to_fifo_i( 5);
      trailer_to_fifo_i( 4) <= trailer_to_fifo_in( 4) OR trailer_to_fifo_i( 4);
      trailer_to_fifo_i( 3) <= trailer_to_fifo_in( 3) OR trailer_to_fifo_i( 3);
      trailer_to_fifo_i( 2) <= trailer_to_fifo_in( 2) OR trailer_to_fifo_i( 2);
      trailer_to_fifo_i( 1) <= trailer_to_fifo_in( 1) OR trailer_to_fifo_i( 1);
      trailer_to_fifo_i( 0) <= trailer_to_fifo_in( 0) OR trailer_to_fifo_i( 0);
    elsif (show_trailer_flags = '1') then
      trailer_to_fifo_i   <= trailer_to_fifo_in;
      trailer_to_fifo_out <= trailer_to_fifo_i;
    end if;
  end if;
end process;

END rtl;

