--------------------------------------------------------------------------
-- Particle Physics Detector Electronics Support 
-- University of Wisconsin
-- Lawrence Berkeley National Laboratory (c) 1999
-- ReadOutDriver Electronics
--  
--------------------------------------------------------------------------
-- Filename: 512x8dpram.vhd
-- Description:
--  FifoBuffer for serial link data stream decoder. 
--  Current implementation is XILINX specific and uses built in 
--  block rams for fifo memories. 
--
--  This block is completely Xilinx specific code,
--  and comes directly from the "xapp130.pdf" file available from 
--  the Xilinx appnote web page.
--  Although there is copious documentation there, it is not all very 
--  clear. Specifically, there are no timing diagrams or examples of
--  how the memories need to be accessed.
--  
--------------------------------------------------------------------------
-- Structure:
--------------------------------------------------------------------------
-- Timing:
--    *The Engine FPGA runs at 40MHz => clk40
--    *The timing structure of all engine code will be:
--      1.  Latch inputs on positive edge of clk40
--      2.  Perform all logic operations on positive edge of clk40
--      3.  Perform all memory operations on positive edge of clk40
--------------------------------------------------------------------------
-- Author:         Mark L. Nagel
-- Board Engineer: 
-- History:
--    08/09/99 MLN First version
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- LIBRARY INCLUDES
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;  -- needed for logic operations
use IEEE.std_logic_arith.all; -- needed for +/- operations

--------------------------------------------------------------------------
-- SIMULATION LIBRARY INCLUDES
--------------------------------------------------------------------------

-- pragma translate_off
library UNISIM;
use unisim.all;
-- pragma translate_on

--------------------------------------------------------------------------
-- PORT DECLARATION
--------------------------------------------------------------------------

entity dpram_512x8 is
  port (
    clk_in           : in  std_logic; -- clk40 input
    rst_n_in         : in  std_logic; -- asynchronous global reset
    dprm_writein_bus : in  std_logic_vector(7 downto 0);
    writein_addr     : in  unsigned(8 downto 0); -- 
    readout_addr     : in  unsigned(8 downto 0); --
    write_strobe     : in  std_logic; --
    read_strobe      : in  std_logic; --
    dprm_readout_bus : out std_logic_vector(7 downto 0)
    );
end dpram_512x8;

--------------------------------------------------------------------------
-- XILINX PARTS SPECIFIC COMPONENTS/SIGNALS
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- SIGNAL DECLARATION
--------------------------------------------------------------------------
architecture behave of dpram_512x8 is

signal gnd          : std_logic;
signal pwr          : std_logic;
signal logic0vector : std_logic_vector(7 downto 0);
signal WIA_I        : std_logic_vector(8 downto 0);
signal ROB_I        : std_logic_vector(8 downto 0);
signal rst_i        : std_logic;

--------------------------------------------------------------------------
-- COMPONENT DECLARATION
--------------------------------------------------------------------------

component RAMB4_S8_S8
  port (
    DOA    : out STD_LOGIC_VECTOR (7 downto 0);
    DOB    : out STD_LOGIC_VECTOR (7 downto 0);
    ADDRA  : in  STD_LOGIC_VECTOR (8 downto 0);
    DIA    : in  STD_LOGIC_VECTOR (7 downto 0);
    ENA    : in  STD_ULOGIC;
    CLKA   : in  STD_ULOGIC;
    WEA    : in  STD_ULOGIC;                
    RSTA   : in  STD_ULOGIC;
    ADDRB  : in  STD_LOGIC_VECTOR (8 downto 0);
    DIB    : in  STD_LOGIC_VECTOR (7 downto 0);
    ENB    : in  STD_ULOGIC;
    CLKB   : in  STD_ULOGIC;
    WEB    : in  STD_ULOGIC;
    RSTB   : in  STD_ULOGIC
    ); 
end component;

attribute INIT_00: string;
attribute INIT_01: string;
attribute INIT_02: string;
attribute INIT_03: string;
attribute INIT_04: string;
attribute INIT_05: string;
attribute INIT_06: string;
attribute INIT_07: string;
attribute INIT_08: string;
attribute INIT_09: string;
attribute INIT_0A: string;
attribute INIT_0B: string;
attribute INIT_0C: string;
attribute INIT_0D: string;
attribute INIT_0E: string;
attribute INIT_0F: string;

attribute INIT_00 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_01 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_02 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_03 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_04 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_05 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_06 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_07 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_08 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_09 of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0A of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0B of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0C of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0D of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0E of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0F of MB: label is
"0000000000000000000000000000000000000000000000000000000000000000";

--------------------------------------------------------------------------
-- COMPONENT INSTANTIATION
--------------------------------------------------------------------------
begin

gnd <= '0';
pwr <= '1';
logic0vector <= (others => '0');

WIA_I <= std_logic_vector (writein_addr);
ROB_I <= std_logic_vector (readout_addr);

rst_i <= NOT rst_n_in;

MB : RAMB4_S8_S8 -- Block[7..0] of 24bits
  port map (
    DOA   => open,             -- DOA
    DOB   => dprm_readout_bus, -- DOB
    ADDRA => WIA_I,            -- ADDRB
    DIA   => dprm_writein_bus, -- DIA 
    ENA   => pwr,              -- ENA
    CLKA  => clk_in,           -- CLKA
    WEA   => write_strobe,     -- WEA   
    RSTA  => rst_i,            -- RSTA   
    ADDRB => ROB_I,            -- ADDRA                                                  
    DIB   => logic0vector,     -- DIB
    ENB   => read_strobe,      -- ENB
    CLKB  => clk_in,           -- CLKB
    WEB   => gnd,              -- WEB  
    RSTB  => rst_i             -- RSTB
   ); 

end behave;
